function [chisquare,chisquaremean,chisquarestd] = get_chisquare(PSF,imagecfg,parameters)
% This function evaluates the chi-square statistic and the expected mean
% and std for a sum of Poisson-distributed variables.
%
% Sjoerd Stallinga, TU Delft

% (C) Copyright 2018
% All rights reserved
% Department of Imaging Physics
% Faculty of Applied Sciences
% Delft University of Technology
% Delft, The Netherlands   

Nph = parameters.signalphotoncount;
bg = parameters.backgroundphotoncount;
rnvar = (parameters.readnoisestd)^2;

mu = Nph*PSF+bg;
chisquare = sum(sum(sum((mu-imagecfg).^2./(mu+rnvar))));

% offset between log(likelihood) and chisquare:
% log(likelihood) \approx -( chisquare + sum(sum(log(2*pi*mu))) )/2
% chisquare = chisquare+sum(sum(sum(log(2*pi*mu))));

% theoretical mean and std
[Mx,My,Mz] = size(PSF);
chisquaremean = Mx*My*Mz;
chisquarestd = 2*Mx*My*Mz+sum(sum(sum(1./(mu+rnvar))));
chisquarestd = sqrt(chisquarestd);

end

